jQuery(document).ready(function($) {
    // Check if the download variables are defined.
    if (typeof rcp_download_vars === 'undefined') {
        console.error('RCP Advanced Tools: Vars not defined.');
        return;
    }

    // The selector looks for links "marked" by our PHP code.
    const selector = 'a[data-rcp-adv-download="true"]';

    // Use event delegation for dynamically added content.
    $(document.body).on('click', selector, function(e) {
        // Prevent the default link behavior.
        e.preventDefault();

        const fileUrl = $(this).attr('href');

        // Show a loading indicator.
        Swal.fire({
            title: 'در حال بررسی دسترسی...',
            text: 'لطفاً چند لحظه صبر کنید.',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        $.ajax({
            type: 'POST',
            url: rcp_download_vars.ajax_url,
            data: {
                action: 'rcp_custom_check_download',
                nonce: rcp_download_vars.nonce,
                file_url: fileUrl,
                post_id: rcp_download_vars.post_id // NEW: Send the post ID
            },
            success: function(response) {
                if (response.success) {
                    // If permission is granted, start the download.
                    Swal.close();
                    window.location.href = response.data.download_url;
                } else {
                    // If permission is denied, show a specific error message.
                    let title = 'خطا';
                    let text = response.data.message || 'شما اجازه دانلود این فایل را ندارید.';
                    let confirmButtonText = 'متوجه شدم';
                    let icon = 'error';

                    switch (response.data.code) {
                        case 'not_logged_in':
                            title = 'نیاز به ورود';
                            text = 'برای دانلود این فایل، لطفاً ابتدا وارد حساب کاربری خود شوید.';
                            confirmButtonText = 'صفحه ورود';
                            Swal.fire({
                                title: title,
                                text: text,
                                icon: 'info',
                                confirmButtonText: confirmButtonText,
                                showCancelButton: true,
                                cancelButtonText: 'انصراف'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location.href = rcp_download_vars.login_url;
                                }
                            });
                            break;

                        case 'limit_reached':
                            title = 'محدودیت دانلود';
                            text = 'سقف دانلود روزانه شما به اتمام رسیده است. لطفاً فردا دوباره تلاش کنید.';
                            Swal.fire({ title: title, text: text, icon: 'warning', confirmButtonText: confirmButtonText });
                            break;

                        case 'no_subscription':
                            title = 'نیاز به اشتراک';
                            text = 'برای دانلود این فایل نیاز به اشتراک فعال دارید.';
                            confirmButtonText = 'مشاهده اشتراک‌ها';
                            Swal.fire({
                                title: title,
                                text: text,
                                icon: 'warning',
                                confirmButtonText: confirmButtonText,
                                showCancelButton: true,
                                cancelButtonText: 'انصراف'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location.href = rcp_download_vars.subscription_url;
                                }
                            });
                            break;
                            
                        default:
                            Swal.fire({ title: title, text: text, icon: icon, confirmButtonText: confirmButtonText });
                            break;
                    }
                }
            },
            error: function() {
                Swal.fire({
                    title: 'خطای سرور',
                    text: 'مشکلی در برقراری ارتباط با سرور پیش آمده است. لطفاً صفحه را رفرش کرده و دوباره تلاش کنید.',
                    icon: 'error',
                    confirmButtonText: 'باشه'
                });
            }
        });
    });
});
