jQuery(document).ready(function($) {
    'use strict';
    
    // Initialize color picker on product page and settings page
    $('.wic-color-picker, .color-picker').wpColorPicker();

    // Product Edit Page: Show/hide contact fields based on selected method
    function toggleProductContactFields() {
        var method = $('#_wic_contact_method').val();
        $('.wic_contact_field').hide();
        if (method === 'whatsapp') {
            $('.wic_whatsapp_field').show();
        } else if (method === 'telegram') {
            $('.wic_telegram_field').show();
        } else if (method && method.startsWith('custom_')) {
            var index = method.replace('custom_', '');
            $('.wic_custom_field_' + index).show();
        }
    }
    if ($('#_wic_contact_method').length) {
        toggleProductContactFields();
        $('#_wic_contact_method').on('change', toggleProductContactFields);
    }

    // Quick Edit: Populate checkbox based on hidden data
    if ($('#the-list').length) {
        $('#the-list').on('click', '.editinline', function() {
            var post_id = $(this).closest('tr').attr('id').replace('post-', '');
            var lease_status = $('#wic-enabled-data-' + post_id).text();
            var is_checked = lease_status === 'yes';
            $('.inline-edit-row input[name="_wic_enabled_quick"]').prop('checked', is_checked);
        });
    }

    // Global Settings Page: Show/hide default contact fields
    if ($('#wic_default_contact_method').length) {
        function toggleDefaultContactFields() {
            var method = $('#wic_default_contact_method').val();
            var whatsapp_field = $('#wic_default_whatsapp_number').closest('tr');
            var telegram_field = $('#wic_default_telegram_id').closest('tr');
            whatsapp_field.hide();
            telegram_field.hide();
            if (method === 'whatsapp') { whatsapp_field.show(); } 
            else if (method === 'telegram') { telegram_field.show(); }
        }
        toggleDefaultContactFields();
        $('#wic_default_contact_method').on('change', toggleDefaultContactFields);
    }

    // Global Settings Page: Custom Messenger Repeater
    if ($('#wic_custom_messengers_repeater').length) {
        $('#add_custom_messenger').on('click', function(e) {
            e.preventDefault();
            var repeater = $('#wic_custom_messengers_repeater');
            var row_count = repeater.find('tbody tr').length;
            var new_row = '<tr>' +
                '<td><input type="text" name="wic_custom_messengers[' + row_count + '][name]" class="input-text" /></td>' +
                '<td><input type="text" name="wic_custom_messengers[' + row_count + '][link]" class="input-text" placeholder="https://eitaa.com/{ID}" /></td>' +
                '<td><input type="checkbox" name="wic_custom_messengers[' + row_count + '][text_support]" value="1" /></td>' +
                '<td><input type="text" name="wic_custom_messengers[' + row_count + '][color]" class="wic-color-picker" value="#0073aa" data-default-color="#0073aa" /></td>' +
                '<td><button type="button" class="button button-secondary remove_custom_messenger">حذف</button></td>' +
                '</tr>';
            repeater.find('tbody').append(new_row);
            $('.wic-color-picker').wpColorPicker();
        });

        repeater.on('click', '.remove_custom_messenger', function(e) {
            e.preventDefault();
            $(this).closest('tr').remove();
        });
    }
});
