document.addEventListener('DOMContentLoaded', function() {
    'use strict';
    
    document.body.addEventListener('click', function(e) {
        const modal = document.getElementById('wic-calculator-modal');
        if (!modal) return;

        // Handle opening the modal
        if (e.target && e.target.id === 'wic-calc-open-btn') {
            e.preventDefault();
            modal.classList.add('active');
        }

        // Handle closing the modal
        const activeModal = document.querySelector('.wic-modal.active');
        if (activeModal) {
            if (e.target === activeModal || e.target.classList.contains('wic-modal-close')) {
                activeModal.classList.remove('active');
            }
        }
    });

    // Handle closing with Escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            const activeModal = document.querySelector('.wic-modal.active');
            if (activeModal) {
                activeModal.classList.remove('active');
            }
        }
    });
});
