<?php
/**
 * Handles all admin-side features of the plugin.
 */
class WIC_Admin {

    private $version;

    public function __construct( $version ) {
        $this->version = $version;
        $this->load_hooks();
    }

    private function load_hooks() {
        add_filter( 'woocommerce_product_data_tabs', [ $this, 'add_installment_product_data_tab' ] );
        add_action( 'woocommerce_product_data_panels', [ $this, 'add_installment_product_data_fields' ] );
        add_action( 'woocommerce_process_product_meta', [ $this, 'save_installment_product_data_fields' ] );
        add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_admin_scripts' ] );
        add_filter( 'manage_product_posts_columns', [ $this, 'add_installment_column_header' ] );
        add_action( 'manage_product_posts_custom_column', [ $this, 'add_installment_column_content' ], 10, 2 );
        add_action( 'woocommerce_product_quick_edit_start', [ $this, 'add_quick_edit_field' ] );
        add_action( 'woocommerce_product_quick_edit_save', [ $this, 'save_quick_edit_field' ] );
        add_action( 'woocommerce_product_bulk_edit_start', [ $this, 'add_bulk_edit_field' ] );
        add_action( 'woocommerce_product_bulk_edit_save', [ $this, 'save_bulk_edit_field' ] );
        add_filter( 'woocommerce_settings_tabs_array', [ $this, 'add_settings_tab' ], 50 );
        add_action( 'woocommerce_settings_tabs_installment_settings', [ $this, 'settings_tab_content' ] );
        add_action( 'woocommerce_update_options_installment_settings', [ $this, 'update_settings' ] );
    }
    
    public function enqueue_admin_scripts( $hook ) {
        global $post, $pagenow;
        if ( ($hook == 'post-new.php' || $hook == 'post.php' && isset($post->post_type) && 'product' === $post->post_type) || ($hook == 'woocommerce_page_wc-settings' && isset($_GET['tab']) && $_GET['tab'] === 'installment_settings') || ($pagenow == 'edit.php' && isset($_GET['post_type']) && $_GET['post_type'] === 'product') ) {
            wp_enqueue_style( 'wp-color-picker' );
            wp_enqueue_script( 'wic-admin-script', WIC_URL . 'assets/js/wic-admin-script.js', [ 'jquery', 'wp-color-picker' ], $this->version, true );
        }
    }

    public function add_installment_product_data_tab( $tabs ) {
        $tabs['installment'] = [
            'label'    => __( 'فروش اقساطی', WIC_TEXT_DOMAIN ),
            'target'   => 'installment_product_data',
            'class'    => [ 'show_if_simple', 'show_if_variable' ],
            'priority' => 80,
        ];
        return $tabs;
    }

    public function add_installment_product_data_fields() {
        global $post;
        echo '<div id="installment_product_data" class="panel woocommerce_options_panel">';
        
        woocommerce_wp_checkbox( [ 'id' => '_wic_enabled', 'label' => __( 'فعال‌سازی فروش اقساطی', WIC_TEXT_DOMAIN ) ] );
        woocommerce_wp_select([ 'id' => '_wic_display_method', 'label' => __('نحوه نمایش', WIC_TEXT_DOMAIN), 'options' => [ '' => __('استفاده از تنظیمات پیش‌فرض', WIC_TEXT_DOMAIN), 'auto' => __('نمایش خودکار', WIC_TEXT_DOMAIN), 'shortcode' => __('فقط با شورت‌کد', WIC_TEXT_DOMAIN) ], 'desc_tip' => true, 'description' => __('انتخاب کنید که کادر محاسبه‌گر چگونه نمایش داده شود.', WIC_TEXT_DOMAIN) ]);
        woocommerce_wp_text_input( [ 'id' => '_wic_down_payment_percent', 'label' => __( 'درصد پیش‌پرداخت', WIC_TEXT_DOMAIN ), 'placeholder' => get_option('wic_default_down_payment', '20'), 'type' => 'number', 'custom_attributes' => [ 'step' => '1', 'min'  => '0', 'max'  => '99' ], 'description' => __( 'اگر خالی باشد، از مقدار پیش‌فرض استفاده می‌شود.', WIC_TEXT_DOMAIN ), 'desc_tip' => true ] );
        woocommerce_wp_text_input( [ 'id' => '_wic_installments', 'label' => __( 'تعداد اقساط (ماه)', WIC_TEXT_DOMAIN ), 'placeholder' => get_option('wic_default_installments', '12'), 'type' => 'number', 'custom_attributes' => [ 'step' => '1', 'min'  => '1' ], 'description' => __( 'اگر خالی باشد، از مقدار پیش‌فرض استفاده می‌شود.', WIC_TEXT_DOMAIN ), 'desc_tip' => true ] );
        woocommerce_wp_text_input( [ 'id' => '_wic_interest_rate', 'label' => __( 'نرخ سود سالانه (درصد)', WIC_TEXT_DOMAIN ), 'placeholder' => get_option('wic_default_interest_rate', '23'), 'type' => 'number', 'custom_attributes' => [ 'step' => '0.1', 'min'  => '0' ], 'description' => __( 'اگر خالی باشد، از مقدار پیش‌فرض استفاده می‌شود.', WIC_TEXT_DOMAIN ), 'desc_tip' => true ] );
        woocommerce_wp_text_input( [ 'id' => '_wic_highlight_color', 'label' => __( 'رنگ تاکید (اختیاری)', WIC_TEXT_DOMAIN ), 'placeholder' => get_option('wic_default_highlight_color', '#28a745'), 'description' => __( 'رنگ مبلغ قسط و دکمه‌های خرید را انتخاب کنید.', WIC_TEXT_DOMAIN ), 'desc_tip' => true, 'class' => 'wic-color-picker' ] );

        echo '<hr style="margin: 20px 12px; border-top: 1px solid #eee;">';

        $contact_methods = [ '' => __('استفاده از تنظیمات پیش‌فرض', WIC_TEXT_DOMAIN), 'none' => __('فقط نمایش محاسبه‌گر', WIC_TEXT_DOMAIN), 'whatsapp' => __('پیام به واتس‌اپ', WIC_TEXT_DOMAIN), 'telegram' => __('پیام به تلگرام', WIC_TEXT_DOMAIN) ];
        $custom_messengers = get_option('wic_custom_messengers', []);
        foreach ($custom_messengers as $index => $messenger) {
            if (!empty($messenger['name'])) { $contact_methods['custom_' . $index] = $messenger['name']; }
        }

        woocommerce_wp_select([ 'id' => '_wic_contact_method', 'label' => __('روش ثبت خرید اقساطی', WIC_TEXT_DOMAIN), 'options' => $contact_methods, 'desc_tip' => true, 'description' => __('انتخاب کنید که مشتری چگونه درخواست خرید اقساطی را ثبت کند.', WIC_TEXT_DOMAIN) ]);
        woocommerce_wp_text_input( [ 'id' => '_wic_whatsapp_number', 'label' => __( 'شماره واتس‌اپ', WIC_TEXT_DOMAIN ), 'placeholder' => get_option('wic_default_whatsapp_number'), 'desc_tip' => true, 'description' => __( 'شماره را با کد کشور و بدون + وارد کنید.', WIC_TEXT_DOMAIN ), 'wrapper_class' => 'form-field-wide wic_contact_field wic_whatsapp_field' ] );
        woocommerce_wp_text_input( [ 'id' => '_wic_telegram_id', 'label' => __( 'آیدی تلگرام', WIC_TEXT_DOMAIN ), 'placeholder' => get_option('wic_default_telegram_id'), 'desc_tip' => true, 'description' => __( 'آیدی تلگرام خود را بدون @ وارد کنید.', WIC_TEXT_DOMAIN ), 'wrapper_class' => 'form-field-wide wic_contact_field wic_telegram_field' ] );
        
        $custom_ids = get_post_meta($post->ID, '_wic_custom_ids', true) ?: [];
        foreach ($custom_messengers as $index => $messenger) {
            if (!empty($messenger['name'])) {
                woocommerce_wp_text_input( [ 'id' => '_wic_custom_ids[' . $index . ']', 'label' => sprintf(__('آیدی/شماره %s', WIC_TEXT_DOMAIN), $messenger['name']), 'value' => $custom_ids[$index] ?? '', 'wrapper_class' => 'form-field-wide wic_contact_field wic_custom_field wic_custom_field_' . $index ] );
            }
        }

        echo '<hr style="margin: 20px 12px; border-top: 1px solid #eee;">';
        echo '<div class="options_group"><p class="form-field form-field-wide"><label>' . __('راهنمای شورت‌کد', WIC_TEXT_DOMAIN) . '</label><span class="description" style="display:block; margin-top:5px;">' . __('برای نمایش محاسبه‌گر در مکان دلخواه، این شورت‌کد را کپی کنید.', WIC_TEXT_DOMAIN) . '</span><code style="direction: ltr; user-select: all; background: #f0f0f1; padding: 5px 10px; border-radius: 4px; border: 1px solid #ddd; display: inline-block; margin-top: 10px;">[wic_details]</code></p></div>';
        echo '<p style="font-size: 12px; color: #777; padding: 0 12px;">توسعه با عشق توسط نوین رنک ❤️</p>';
        echo '</div>';
    }

    public function save_installment_product_data_fields( $post_id ) {
        $fields = ['_wic_enabled', '_wic_display_method', '_wic_down_payment_percent', '_wic_installments', '_wic_interest_rate', '_wic_highlight_color', '_wic_contact_method', '_wic_whatsapp_number', '_wic_telegram_id'];
        foreach ($fields as $field) {
            $value = isset($_POST[$field]) ? sanitize_text_field($_POST[$field]) : '';
            if ($field === '_wic_enabled') $value = isset($_POST[$field]) ? 'yes' : 'no';
            if ($field === '_wic_highlight_color') $value = sanitize_hex_color($_POST[$field]);
            update_post_meta($post_id, $field, $value);
        }
        if (isset($_POST['_wic_custom_ids']) && is_array($_POST['_wic_custom_ids'])) {
            update_post_meta($post_id, '_wic_custom_ids', array_map('sanitize_text_field', $_POST['_wic_custom_ids']));
        }
    }

    public function add_installment_column_header( $columns ) { $columns['installment_enabled'] = '<span class="dashicons dashicons-calculator" title="' . __('فروش اقساطی', WIC_TEXT_DOMAIN) . '"></span>'; return $columns; }
    public function add_installment_column_content( $column, $post_id ) { if ( $column === 'installment_enabled' ) { $is_enabled = get_post_meta( $post_id, '_wic_enabled', true ); $icon = $is_enabled === 'yes' ? 'yes-alt' : 'no'; $title = $is_enabled === 'yes' ? 'فعال' : 'غیرفعال'; echo '<span class="dashicons dashicons-' . $icon . '" title="' . esc_attr($title) . '"></span>'; echo '<span class="hidden" id="wic-enabled-data-' . esc_attr($post_id) . '">' . esc_attr($is_enabled) . '</span>'; } }
    public function add_quick_edit_field() { echo '<fieldset class="inline-edit-col-right"><div class="inline-edit-col"><label class="alignleft"><input type="checkbox" name="_wic_enabled_quick" value="yes"><span class="checkbox-title">' . __('فروش اقساطی', WIC_TEXT_DOMAIN) . '</span></label></div></fieldset>'; }
    public function save_quick_edit_field( $product ) { if (isset($_REQUEST['_wic_enabled_quick'])) { update_post_meta($product->get_id(), '_wic_enabled', 'yes'); } else { update_post_meta($product->get_id(), '_wic_enabled', 'no'); } }
    public function add_bulk_edit_field() { echo '<label class="alignleft"><span class="title">' . __('فروش اقساطی', WIC_TEXT_DOMAIN) . '</span><span class="input-text-wrap"><select name="_wic_enabled_bulk"><option value="-1">— ' . __('بدون تغییر', WIC_TEXT_DOMAIN) . ' —</option><option value="yes">' . __('فعال', WIC_TEXT_DOMAIN) . '</option><option value="no">' . __('غیرفعال', WIC_TEXT_DOMAIN) . '</option></select></span></label>'; }
    public function save_bulk_edit_field( $product ) { if (isset($_REQUEST['_wic_enabled_bulk']) && in_array($_REQUEST['_wic_enabled_bulk'], ['yes', 'no'])) { update_post_meta($product->get_id(), '_wic_enabled', $_REQUEST['_wic_enabled_bulk']); } }
    public function add_settings_tab( $settings_tabs ) { $settings_tabs['installment_settings'] = __( 'فروش اقساطی', WIC_TEXT_DOMAIN ); return $settings_tabs; }
    public function settings_tab_content() { woocommerce_admin_fields( $this->get_settings() ); $this->render_custom_messenger_table(); echo '<p style="margin-top: 20px; text-align: center; color: #777;">توسعه با عشق توسط نوین رنک ❤️</p>'; }
    public function update_settings() { 
        woocommerce_update_options( $this->get_settings() ); 
        if (isset($_POST['wic_custom_messengers'])) {
            $messengers = [];
            foreach ($_POST['wic_custom_messengers'] as $messenger) {
                if (!empty($messenger['name']) && !empty($messenger['link'])) {
                    $messengers[] = [
                        'name' => sanitize_text_field($messenger['name']),
                        'link' => esc_url_raw($messenger['link']),
                        'text_support' => isset($messenger['text_support']) ? 1 : 0,
                        'color' => sanitize_hex_color($messenger['color']),
                    ];
                }
            }
            update_option('wic_custom_messengers', $messengers);
        } else {
            update_option('wic_custom_messengers', []);
        }
    }
    public function get_settings() {
        return apply_filters('wic_settings', [
            ['name' => __('تنظیمات پیش‌فرض فروش اقساطی', WIC_TEXT_DOMAIN), 'type' => 'title', 'id' => 'wic_settings_section_title'],
            ['name' => __('نحوه نمایش پیش‌فرض', WIC_TEXT_DOMAIN), 'type' => 'select', 'id' => 'wic_default_display_method', 'options' => ['auto' => __('نمایش خودکار', WIC_TEXT_DOMAIN), 'shortcode' => __('فقط با شورت‌کد', WIC_TEXT_DOMAIN)], 'default' => 'auto'],
            ['name' => __('درصد پیش‌پرداخت پیش‌فرض', WIC_TEXT_DOMAIN), 'type' => 'number', 'id' => 'wic_default_down_payment', 'default' => '20'],
            ['name' => __('تعداد اقساط پیش‌فرض (ماه)', WIC_TEXT_DOMAIN), 'type' => 'number', 'id' => 'wic_default_installments', 'default' => '12'],
            ['name' => __('نرخ سود سالانه پیش‌فرض (درصد)', WIC_TEXT_DOMAIN), 'type' => 'number', 'id' => 'wic_default_interest_rate', 'custom_attributes' => ['step' => '0.1'], 'default' => '23'],
            ['name' => __('رنگ تاکید پیش‌فرض', WIC_TEXT_DOMAIN), 'type' => 'color', 'id' => 'wic_default_highlight_color', 'default' => '#28a745'],
            ['name' => __('روش ثبت خرید پیش‌فرض', WIC_TEXT_DOMAIN), 'type' => 'select', 'id' => 'wic_default_contact_method', 'options' => ['none' => __('فقط نمایش محاسبه‌گر', WIC_TEXT_DOMAIN), 'whatsapp' => __('پیام به واتس‌اپ', WIC_TEXT_DOMAIN), 'telegram' => __('پیام به تلگرام', WIC_TEXT_DOMAIN)], 'default' => 'none'],
            ['name' => __('شماره واتس‌اپ پیش‌فرض', WIC_TEXT_DOMAIN), 'type' => 'text', 'id' => 'wic_default_whatsapp_number', 'placeholder' => '989123456789'],
            ['name' => __('آیدی تلگرام پیش‌فرض', WIC_TEXT_DOMAIN), 'type' => 'text', 'id' => 'wic_default_telegram_id', 'placeholder' => 'your_telegram_id'],
            ['type' => 'sectionend', 'id' => 'wic_settings_section_end']
        ]);
    }
    public function render_custom_messenger_table() {
        $messengers = get_option('wic_custom_messengers', []);
        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <h2><?php _e('پیام‌رسان‌های سفارشی', WIC_TEXT_DOMAIN); ?></h2>
                <p class="description" style="font-weight: normal;"><?php _e('پیام‌رسان‌های دلخواه خود (مانند ایتا، بله و...) را اضافه کنید. این پیام‌رسان‌ها به لیست روش‌های ثبت خرید اضافه خواهند شد.', WIC_TEXT_DOMAIN); ?></p>
            </th>
            <td class="forminp">
                <table id="wic_custom_messengers_repeater" class="wc_input_table widefat">
                    <thead>
                        <tr>
                            <th><?php _e('نام پیام‌رسان', WIC_TEXT_DOMAIN); ?></th>
                            <th><?php _e('الگوی لینک', WIC_TEXT_DOMAIN); ?></th>
                            <th><?php _e('پشتیبانی از متن', WIC_TEXT_DOMAIN); ?></th>
                            <th><?php _e('رنگ دکمه', WIC_TEXT_DOMAIN); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($messengers as $i => $messenger) : ?>
                            <tr>
                                <td><input type="text" name="wic_custom_messengers[<?php echo $i; ?>][name]" class="input-text" value="<?php echo esc_attr($messenger['name']); ?>" /></td>
                                <td><input type="text" name="wic_custom_messengers[<?php echo $i; ?>][link]" class="input-text" placeholder="https://eitaa.com/{ID}" value="<?php echo esc_attr($messenger['link']); ?>" /></td>
                                <td><input type="checkbox" name="wic_custom_messengers[<?php echo $i; ?>][text_support]" value="1" <?php checked(1, $messenger['text_support']); ?> /></td>
                                <td><input type="text" name="wic_custom_messengers[<?php echo $i; ?>][color]" class="wic-color-picker" value="<?php echo esc_attr($messenger['color']); ?>" /></td>
                                <td><button type="button" class="button button-secondary remove_custom_messenger"><?php _e('حذف', WIC_TEXT_DOMAIN); ?></button></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="5"><button type="button" id="add_custom_messenger" class="button button-primary"><?php _e('افزودن پیام‌رسان جدید', WIC_TEXT_DOMAIN); ?></button></th>
                        </tr>
                    </tfoot>
                </table>
            </td>
        </tr>
        <?php
    }
}
