<?php
/**
 * Plugin Name:       محاسبه‌ گر اقساط ووکامرس
 * Description:       افزونه پیشرفته افزودن شرایط فروش اقساطی به محصولات ووکامرس و نمایش ماشین حساب در صفحه محصول.
 * Version:           1.0.0
 * Author:            Novinranke
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       woocommerce-installment-calculator
 * Domain Path:       /languages
 * WC requires at least: 3.0.0
 * WC tested up to: 8.4.0
 */

// Prevent direct file access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Check if WooCommerce is active
if ( ! in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    add_action( 'admin_notices', function() {
        echo '<div class="error"><p><strong>افزونه محاسبه‌گر اقساط:</strong> برای کارکرد این افزونه، لطفاً ابتدا ووکامرس را نصب و فعال کنید.</p></div>';
    });
    return;
}

// Define Plugin Constants
define( 'WIC_VERSION', '3.9.1' );
define( 'WIC_PATH', plugin_dir_path( __FILE__ ) );
define( 'WIC_URL', plugin_dir_url( __FILE__ ) );
define( 'WIC_TEXT_DOMAIN', 'woocommerce-installment-calculator' );

/**
 * Load plugin textdomain for translations.
 */
function wic_load_textdomain() {
    load_plugin_textdomain( WIC_TEXT_DOMAIN, false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' ); 
}
add_action( 'plugins_loaded', 'wic_load_textdomain' );

/**
 * Load plugin classes.
 */
require_once WIC_PATH . 'includes/admin/class-wic-admin.php';
require_once WIC_PATH . 'includes/public/class-wic-public.php';

/**
 * Initialize plugin classes
 */
if ( class_exists( 'WIC_Admin' ) ) {
    new WIC_Admin( WIC_VERSION );
}

if ( class_exists( 'WIC_Public' ) ) {
    new WIC_Public( WIC_VERSION );
}
