<?php
/**
 * Class Amazon_Price_Calculator_Admin
 *
 * مدیریت تمام فعالیت‌های مربوط به بخش مدیریت وردپرس.
 */
class Amazon_Price_Calculator_Admin {

    /**
     * @var array فیلدهای تنظیمات افزونه.
     */
    private $settings_fields;

    /**
     * @var array گزینه‌های ذخیره شده در دیتابیس.
     */
    private $options;

    /**
     * سازنده کلاس.
     *
     * @param array $settings_fields آرایه‌ای از فیلدهای تنظیمات.
     */
    public function __construct($settings_fields) {
        $this->settings_fields = $settings_fields;
        $this->options = get_option('apc_settings');
    }

    /**
     * اضافه کردن صفحه تنظیمات به منوی وردپرس.
     */
    public function add_plugin_page() {
        add_menu_page(
            'تنظیمات محاسبه‌گر قیمت',
            'محاسبه‌گر آمازون',
            'manage_options',
            'amazon-price-calculator',
            array($this, 'render_admin_page'),
            'dashicons-money-alt',
            25
        );
    }

    /**
     * رندر کردن صفحه تنظیمات افزونه.
     */
    public function render_admin_page() {
        ?>
        <div class="wrap">
            <h1>تنظیمات محاسبه‌گر قیمت آمازون</h1>
            <div style="background: #fff; border: 1px solid #c3c4c7; padding: 1px 12px; margin-top: 15px; border-right-width: 4px; border-right-color: #4CAF50;">
                <h2>راهنمای استفاده</h2>
                <p>برای نمایش فرم، شورت‌کد زیر را کپی و در ویرایشگر مورد نظر خود جای‌گذاری کنید:</p>
                <p><input type="text" value="[amazon_price_calculator]" readonly="readonly" style="width: 100%; text-align: center; font-weight: bold;"></p>
            </div>
            <form method="post" action="options.php" style="margin-top: 20px;">
                <?php
                    settings_fields('apc_option_group');
                    do_settings_sections('apc-setting-admin');
                    submit_button();
                ?>
                 <p style="text-align: center; margin-top: 20px; margin-bottom: 10px; font-size: 14px;">
                    توسعه با عشق توسط <a href="https://novinranke.ir/" target="_blank" rel="noopener noreferrer" style="font-weight: bold; text-decoration: none; color: #16a34a;">نوین رنک</a>
                </p>
            </form>
        </div>
        <?php
    }

    /**
     * ثبت تنظیمات، بخش‌ها و فیلدها.
     */
    public function register_settings() {
        register_setting('apc_option_group', 'apc_settings', array($this, 'sanitize_input'));

        add_settings_section('apc_main_settings_section', 'تنظیمات اصلی', null, 'apc-setting-admin');
        add_settings_section('apc_text_settings_section', 'شخصی‌سازی متون', null, 'apc-setting-admin');
        add_settings_section('apc_style_settings_section', 'شخصی‌سازی ظاهر', null, 'apc-setting-admin');

        foreach ($this->settings_fields as $id => $field) {
            $field['id'] = $id;
            add_settings_field(
                $id,
                $field['title'],
                array($this, 'render_field'),
                'apc-setting-admin',
                $field['section'],
                $field
            );
        }
    }

    /**
     * پاک‌سازی ورودی‌های کاربر قبل از ذخیره در دیتابیس.
     *
     * @param array $input ورودی‌های خام از فرم.
     * @return array ورودی‌های پاک‌سازی شده.
     */
    public function sanitize_input($input) {
        $new_input = array();
        foreach ($input as $key => $value) {
            if (isset($input[$key])) {
                if ($key === 'main_color') {
                    $new_input[$key] = sanitize_hex_color($value);
                } elseif ($key === 'source_site_url') {
                    $new_input[$key] = esc_url_raw($value);
                } else {
                    $new_input[$key] = sanitize_text_field($value);
                }
            }
        }
        return $new_input;
    }

    /**
     * رندر کردن یک فیلد ورودی در صفحه تنظیمات.
     *
     * @param array $args آرگومان‌های مربوط به فیلد.
     */
    public function render_field($args) {
        $value = isset($this->options[$args['id']]) ? esc_attr($this->options[$args['id']]) : $args['default'];
        $placeholder = isset($args['placeholder']) ? 'placeholder="' . esc_attr($args['placeholder']) . '"' : '';
        $type = isset($args['type']) ? $args['type'] : 'text';

        printf(
            '<input type="%s" id="%s" name="apc_settings[%s]" value="%s" %s class="regular-text" />',
            $type,
            $args['id'],
            $args['id'],
            $value,
            $placeholder
        );
    }
}
