<?php
/**
 * Class Amazon_Price_Calculator_Main
 *
 * کلاس اصلی افزونه که مسئولیت مدیریت و هماهنگی بخش‌های مختلف را بر عهده دارد.
 */
class Amazon_Price_Calculator_Main {

    /**
     * @var object شیء مربوط به کلاس مدیریت.
     */
    protected $admin;

    /**
     * @var object شیء مربوط به کلاس کاربری.
     */
    protected $frontend;

    /**
     * سازنده کلاس.
     * بارگذاری فایل‌های مورد نیاز و تعریف هوک‌ها.
     */
    public function __construct() {
        $this->load_dependencies();
        $this->define_hooks();
    }

    /**
     * بارگذاری فایل‌های کلاس‌های مدیریت و کاربری.
     */
    private function load_dependencies() {
        require_once APC_PATH . 'includes/class-apc-admin.php';
        require_once APC_PATH . 'includes/class-apc-frontend.php';
    }

    /**
     * تعریف هوک‌های اصلی وردپرس برای اجرای متدهای مربوطه.
     */
    private function define_hooks() {
        $this->admin = new Amazon_Price_Calculator_Admin( $this->get_settings_fields() );
        $this->frontend = new Amazon_Price_Calculator_Frontend( $this->get_settings_fields() );

        // هوک‌های بخش مدیریت
        add_action('admin_menu', array($this->admin, 'add_plugin_page'));
        add_action('admin_init', array($this->admin, 'register_settings'));

        // هوک‌های بخش کاربری
        add_action('wp_enqueue_scripts', array($this->frontend, 'enqueue_assets'));
        add_shortcode('amazon_price_calculator', array($this->frontend, 'render_shortcode'));
    }
    
    /**
     * تعریف فیلدهای تنظیمات افزونه در یک مکان مرکزی.
     * @return array آرایه‌ای از تمام فیلدهای تنظیمات.
     */
    private function get_settings_fields() {
        return [
            'whatsapp_number' => ['title' => 'شماره واتس‌اپ', 'section' => 'apc_main_settings_section', 'type' => 'text', 'default' => '', 'placeholder' => 'شماره واتس‌اپ خود را وارد نمایید'],
            'currency_symbol' => ['title' => 'واحد پول (مثال: درهم)', 'section' => 'apc_main_settings_section', 'type' => 'text', 'default' => 'درهم'],
            'exchange_rate' => ['title' => 'قیمت روز ارز (مثال درهم: 16000)', 'section' => 'apc_main_settings_section', 'type' => 'number', 'default' => '16000'],
            'profit_percentage' => ['title' => 'درصد کارمزد (مثال: 40)', 'section' => 'apc_main_settings_section', 'type' => 'number', 'default' => '40'],
            'source_site_text' => ['title' => 'متن سایت منبع (مثال: Amazon.ae)', 'section' => 'apc_main_settings_section', 'type' => 'text', 'default' => 'Amazon.ae'],
            'source_site_url' => ['title' => 'آدرس سایت منبع (مثال: https://amazon.ae)', 'section' => 'apc_main_settings_section', 'type' => 'url', 'default' => 'https://www.amazon.ae'],
            'form_title' => ['title' => 'عنوان اصلی فرم', 'section' => 'apc_text_settings_section', 'type' => 'text', 'default' => 'محاسبه قیمت تمام شده از آمازون'],
            'form_subtitle' => ['title' => 'زیرعنوان فرم', 'section' => 'apc_text_settings_section', 'type' => 'text', 'default' => 'لینک محصول و قیمت آن به درهم را از سایت منبع وارد کنید.'],
            'url_placeholder' => ['title' => 'متن نگهدارنده لینک', 'section' => 'apc_text_settings_section', 'type' => 'text', 'default' => '۱. لینک محصول را اینجا وارد کنید...'],
            'price_placeholder' => ['title' => 'متن نگهدارنده قیمت', 'section' => 'apc_text_settings_section', 'type' => 'text', 'default' => '۲. قیمت محصول را اینجا وارد کنید (مثال: 1,305.00)'],
            'button_text' => ['title' => 'متن دکمه محاسبه', 'section' => 'apc_text_settings_section', 'type' => 'text', 'default' => 'استعلام قیمت'],
            'results_title' => ['title' => 'عنوان بخش نتایج', 'section' => 'apc_text_settings_section', 'type' => 'text', 'default' => 'نتایج محاسبه قیمت'],
            'shipping_air_text' => ['title' => 'متن ارسال هوایی', 'section' => 'apc_text_settings_section', 'type' => 'text', 'default' => '✈️ هوایی (۱۵ روزه)'],
            'shipping_sea_text' => ['title' => 'متن ارسال دریایی', 'section' => 'apc_text_settings_section', 'type' => 'text', 'default' => '🚢 دریایی (۱ ماه)'],
            'whatsapp_button_text' => ['title' => 'متن دکمه ثبت سفارش', 'section' => 'apc_text_settings_section', 'type' => 'text', 'default' => 'ثبت سفارش'],
            'footer_text' => ['title' => 'متن پاورقی', 'section' => 'apc_text_settings_section', 'type' => 'text', 'default' => 'هزینه‌های باربری جداگانه لحاظ می‌گردد.'],
            'main_color' => ['title' => 'رنگ اصلی فرم', 'section' => 'apc_style_settings_section', 'type' => 'color', 'default' => '#16a34a'],
            'max_width' => ['title' => 'حداکثر عرض فرم (پیکسل)', 'section' => 'apc_style_settings_section', 'type' => 'number', 'default' => '500'],
            'title_font_size' => ['title' => 'اندازه فونت عنوان اصلی (پیکسل)', 'section' => 'apc_style_settings_section', 'type' => 'number', 'default' => '24'],
            'subtitle_font_size' => ['title' => 'اندازه فونت زیرعنوان (پیکسل)', 'section' => 'apc_style_settings_section', 'type' => 'number', 'default' => '15'],
            'body_font_size' => ['title' => 'اندازه فونت متن عمومی (پیکسل)', 'section' => 'apc_style_settings_section', 'type' => 'number', 'default' => '16'],
            'button_font_size' => ['title' => 'اندازه فونت دکمه‌ها (پیکسل)', 'section' => 'apc_style_settings_section', 'type' => 'number', 'default' => '18'],
        ];
    }
    
    /**
     * متد خالی برای اجرای کلاس.
     */
    public function run() {
        // این متد فعلا خالی است اما می‌تواند برای اجرای منطق‌های اولیه استفاده شود.
    }
}
